<!doctype html>
<!--[if IE 6 ]><html lang="en-us" class="ie6"> <![endif]-->
<!--[if IE 7 ]><html lang="en-us" class="ie7"> <![endif]-->
<!--[if IE 8 ]><html lang="en-us" class="ie8"> <![endif]-->
<!--[if (gt IE 7)|!(IE)]><!-->
<html lang="en-us">
<!--<![endif]-->

<head>
    <meta charset="utf-8">
    <title>PeoplePro - Attendance Device Addon</title>
    <meta name="description" content="Attendance Device Addon for PeoplePro- HR Management System" />
    <meta name="author" content="LionCoders">
    <meta name="copyright" content="LionCoders">
    <!-- Google fonts - Roboto -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:400,700">
    <link rel="stylesheet" href="public/documentation/attendance_device_addon/assets/css/documenter_style.css" media="all">
    <link rel="stylesheet" href="public/documentation/attendance_device_addon/assets/css/jquery.mCustomScrollbar.css" media="all">

    <script src="public/documentation/attendance_device_addon/assets/js/jquery.js"></script>
    <script src="public/documentation/attendance_device_addon/assets/js/jquery.mCustomScrollbar.js"></script>
    <script src="public/documentation/attendance_device_addon/assets/js/typeAhead.js"></script>
    <script src="public/documentation/attendance_device_addon/assets/js/script.js"></script>
</head>

<body>
<div id="documenter_sidebar">
    <img src="public/documentation/attendance_device_addon/assets/images/logo.png" style="border: none;margin: 0 10px -10px;width: 40px">
    <h1 style="display: inline;margin-top: -10px">PeoplePro - Attendance Device Addon</h1>

    <ul id="documenter_nav">
        <li><a class="current" href="#documenter_cover">Start</a></li>
        <li><a href="#requirement" title="REQUIREMENTS">Requirements</a></li>
        <li><a href="#install" title="INSTALL">Install</a></li>
        <li><a href="#how_to_use" title="How to Use">How to Use</a></li>
        <li><a href="#video_tutorial" title="Video Tutorial">Video Tutorial</a></li>
        <li><a href="#support" title="SUPPORT">Support</a></li>
    </ul>
</div>
<div id="documenter_content">


    <div id="the-basics">
        <input class="typeahead form-control" type="text" placeholder="Search">
    </div>


    <section id="documenter_cover">
        <h1>PeoplePro - Attendance Device Addon
        </h1>
        <div id="documenter_buttons">
        </div>
        <hr>
        <ul>
            <li>by : LionCoders</li>
            <li>Support : <a href="mailto:support@lion-coders.com">support@lion-coders.com</a></li>
        </ul>
        <p>PeoplePro - Attendance Device Addon extends our popular HR software PeoplePro to manage the attendance taken by the biometric device in your organization.
        </p>
    </section>
    <section id="requirement">
        <div class="page-header">
            <h3>REQUIREMENT</h3>
            <hr class="notop">
        </div>
        <p>
            To integrate the addon, you need to have existing installation of our HR software PeoplePro.
        </p>
    </section>
    <section id="install">
        <div class="page-header">
            <h3>INSTALL</h3>
            <hr class="notop">
        </div>
        <p>
        Unzip the folder you downloaded from Codecanyon. Copy the 'resources' folder from it and delete the existing 'resources' folder from your project folder where peoplepro installed. Then paste the copied one.
        </p>
        <p>
        <iframe width="560" height="315" src="https://www.youtube.com/embed/aJpehJfH3R0" title="PeoplePro - Attendance Device Addon" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
        </p>
        <p>
            Congratulations! You have successfully installed the addon.
        </p>

        <h2><strong>Help with installation</strong></h2>
        <p>
            We can help you install on any cpanel based hosting for as little as $15. You can send the money via paypal to tarik_17@yahoo.co.uk. Contact us at support@lion-coders.com with you hosting details and payment proof and we'll take care of the rest.
        </p>
        <p>
            <b>Please note -</b> If you are installing on localhost, we'll charge $50 for anydesk/teamviewer support(installation).
        </p>
    </section>
    <section id="how_to_use">
        <div class="page-header">
            <h3>How to Use</h3>
            <hr class="notop">
        </div>
        <p>
            1. Export employee list from our software.
            <img alt="" src="public/documentation/attendance_device_addon/assets/images/1.png">
        </p>
        <p>
            2. Set IP in the attendance device.
            <img alt="" src="public/documentation/attendance_device_addon/assets/images/2.png">
        </p>
        <p>
            3. Connect the device to device provider software. For example: connect ZKTeco to ZKTeco attendance software.
            <img alt="" src="public/documentation/attendance_device_addon/assets/images/3.png">
        </p>
        <p>
            4. Import employee list to device provider software.
            <img alt="" src="public/documentation/attendance_device_addon/assets/images/4.png">
        </p>
        <p>
            5. Add employee to device.
            <img alt="" src="public/documentation/attendance_device_addon/assets/images/5.png">
        </p>
        <p>
            6. Take attendance via device.
            <img alt="" src="public/documentation/attendance_device_addon/assets/images/6.png">
        </p>
        <p>
            7. Export attendance log from device provider software.
            <img alt="" src="public/documentation/attendance_device_addon/assets/images/7.png">
        </p>
        <p>
            8. Set attendance device date format in our software peoplepro.
            <img alt="" src="public/documentation/attendance_device_addon/assets/images/8.png">
        </p>
        <p>
            9. Import attendance log in our software peoplepro.
            <img alt="" src="public/documentation/attendance_device_addon/assets/images/9.png">
        </p>
    </section>
    <section id="video_tutorial">
        <div class="page-header">
            <h3>VIDEO TUTORIAL</h3>
            <hr class="notop">
        </div>
        <p>
        <iframe width="560" height="315" src="https://www.youtube.com/embed/OKSx1rjo88E" title="PeoplePro - Attendance Device Addon" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
    </section>
    <section id="support">
        <div class="page-header">
            <h3>SUPPORT</h3>
            <hr class="notop">
        </div>
        <p> We are happy to provide support for any issues within our software. We also provide customization service for as little as $15/hour. So if you have any features in mind or suugestions, please feel free to email us at support@lion-coders.com. Please note that we don't provide support though any other means (example- whatsapp, comments etc.). So, please refrain from commenting your queries on codecanyon or kocking us elsewhere.</p>
        <p>Also, in case of any errors/bugs/issues on your installation, please contact us with your hosting details (url, username, password), software admin access (url, username, password) and purchase code. If your support period has expired, please renew support on codecanyon before contacting us for support.</p>
        <p>Thank you and with best wishes - <a href="http://lion-coders.com">LionCoders</a></p>
    </section>
</div>
<script type="text/javascript">

    $("#documenter_sidebar").mCustomScrollbar({
        theme: "light",
        scrollInertia: 200
    });


    var substringMatcher = function (strs) {
        return function findMatches(q, cb) {
            var matches, substringRegex;

            // an array that will be populated with substring matches
            matches = [];

            // regex used to determine if a string contains the substring `q`
            substrRegex = new RegExp(q, 'i');

            // iterate through the pool of strings and for any string that
            // contains the substring `q`, add it to the `matches` array
            $.each(strs, function (i, str) {
                if (substrRegex.test(str)) {
                    matches.push(str);
                }
            });

            cb(matches);
        };
    };

    var states = ['Start',
        'Requirements',
        'Install',
        'Software Update',
        'Log In',
        'Admin Dashboard',
        'Empty Database',
        'Datatable Options',
        'Location',
        'Company',
        'Department',
        'Designation',
        'Office Shift',
        'Account List',
        'Roles Access',
        'General Setting',
        'Mail Server',
        'Language Setting',
        'Variable Type',
        'Variable Method',
        'Employee List',
        'Import Employee',
        'User List',
        'Assign Role',
        'User Last Login',
        'Location',
        'Award',
        'Travel',
        'Transfer',
        'Resignation',
        'Complaint',
        'Warning',
        'Termination',
        'Announcement',
        'Company Policy',
        'Attendance',
        'Datewise Attendance',
        'Monthly Attendance',
        'Update Attendance',
        'Import Attendance',
        'Manage Holiday',
        'Manage Leave',
        'Payslip Report',
        'Attendance Report',
        'Training Report',
        'Project Report',
        'Task Report',
        'Employee Report',
        'Account Report',
        'Expense Report',
        'Deposit Report',
        'Transaction Report',
        'Job Post',
        'Job Candidate',
        'Job Interview',
        'CMS',
        'New Payment',
        'Payslip History',
        'HR Calendar',
        'Event',
        'Meeting',
        'Client',
        'Tax Type',
        'Project',
        'Task',
        'Invoice',
        'Support Ticket',
        'Account Balance',
        'Payee',
        'Payer',
        'Deposit',
        'Expense',
        'Transaction',
        'Transfer',
        'Asset Category',
        'Asset',
        'File Configuration',
        'File Manager',
        'Official Document',
        'Client Dashboard',
        'Client Project',
        'Client Task',
        'Client Invoice',
        'Client Invoice Paid',
        'Employee Dashboard',
        'Support',
        'General Error'
    ];

    $('#the-basics .typeahead').typeahead({
            hint: true,
            highlight: true,
            minLength: 1
        },
        {
            name: 'states',
            source: substringMatcher(states)
        });

    $('.typeahead').bind('typeahead:select', function (ev, suggestion) {
        let a = suggestion.toLowerCase();
        a = a.replace(/\s+/g, "_");

        let site_url = window.location.href;

        site_url = site_url.split("#")[0];

        window.location.href = site_url + '#' + a;
    });


</script>
</body>

</html>
